-- 1. Create any custom particle properties
pAge              = Allocate(1);  
pSpin             = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed   = Allocate(1); -- Allocate a TReal spin member
pVelocity       = Allocate(2) ;

-- 2. Set the particle texture and blend mode
  SetTexture("sweat");
  SetBlendMode(kBlendNormal, 0);


-- 3. Set the number of particle in the system
SetNumParticles(3);

-- 4. Set up the particle initializer function
pPosition:Init(fRange(Vec2(-10,-10), Vec2(10,10)));

pScale:Init(fRange(0,0));

pAge:Init(fRange(0,0));

pVelocity:Init( fRange( Vec2(-50,-200), Vec2(50, -250)));


StopSpouting = NewTimeout(1.3);
TestDone = NewTimeout(1.3);

-- 5. Set up the particle animation function
pScale:Anim( fFade(pAge,pScale, 0, 0,  200,1,1300,0));

pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,300)) );

pPosition:Anim( pPosition + fTimeScale(pVelocity) );

pAge:Anim(pAge + fAge());

-- Spin by pSpinSpeed scaled by time
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

pUp:Anim( f2dRotation( pSpin ) );


Anim(fExpire(fGreater(pAge,1300)));

-- 6. Defines an Upate function that create particle
function Update(ms)
  if (TestDone(ms)) then
    Done();
    return ;
  end

if StopSpouting(ms) then
  return;
end
 CreateParticles(1);

end
